	subroutine SHAPE(iout, idbg, Ne, Nn, Ng, V, ie, x, xg, e, &
			  Shp, dNdr, Wgt, J, Jac, Ji, Jaci, aopt)
! calculate element shape functions

	implicit none
	integer iout, idbg
	integer Ne, Nn, Ng			! array parameters
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	real*8 V(Ne,2)				! global  arrays
	real*8 xg(Ng)				! Gauss abscissas [-1,+1]
	real*8 J(2,2,Ng,Ng), Ji(2,2,Ng,Ng), Jac(Ng,Ng), Jaci(Ng,Ng)	! geometric entities
	real*8 Shp(4,Ng,Ng), dNdr(4,2,Ng,Ng), Wgt(4,Ng,Ng)	! shape and weight functions
	real*8 aopt				! SUPG alpha_opt
	integer e

	integer i1, i2, i3, i4, g1, g2, ierror
	real*8 r, s
	real*8 h13, h24, h, Vabs

	data ierror /0/

!	write(idbg,'(a)') ' --- SHAPE ---'	! ### TEMPORARY ###

	i1 = ie(e,1)			! 1st node
	i2 = ie(e,2)			! 2nd node
	i3 = ie(e,3)			! 3rd node
	i4 = ie(e,4)			! 4th node
! assume the cell size, h, is the larger diagonal
	h13 = ( x(i3,1) - x(i1,1) )**2 + ( x(i3,2) - x(i1,2) )**2	! diagonal 1->3 ^2
	h24 = ( x(i4,1) - x(i2,1) )**2 + ( x(i4,2) - x(i2,2) )**2	! diagonal 2->4 ^2
	h = sqrt( max( h13, h24 ) )					! element size
	Vabs = sqrt( V(e,1)**2 + V(e,2)**2 )				! |Vi|

	do g1 = 1, Ng
	  r = xg(g1)
	  do g2 = 1, Ng
	    s = xg(g2)

! linear 2D shape functions
! -1 < r, s < +1
! Ni(r,s) = (1 +/- r)(1 +/- s) / 4
	    Shp(1,g1,g2) = 0.25d0 * (1.-r) * (1.-s)	! N1(r,s)
	    Shp(2,g1,g2) = 0.25d0 * (1.+r) * (1.-s)	! N2(r,s)
	    Shp(3,g1,g2) = 0.25d0 * (1.+r) * (1.+s)	! N3(r,s)
	    Shp(4,g1,g2) = 0.25d0 * (1.-r) * (1.+s)	! N4(r,s)

	    dNdr(1,1,g1,g2) =-0.25d0 * (1.-s)		! dN1(r,s)/dr
	    dNdr(2,1,g1,g2) = 0.25d0 * (1.-s)		! dN2(r,s)/dr
	    dNdr(3,1,g1,g2) = 0.25d0 * (1.+s)		! dN3(r,s)/dr
	    dNdr(4,1,g1,g2) =-0.25d0 * (1.+s)		! dN4(r,s)/dr

	    dNdr(1,2,g1,g2) =-0.25d0 * (1.-r)		! dN1(r,s)/ds
	    dNdr(2,2,g1,g2) =-0.25d0 * (1.+r)		! dN2(r,s)/ds
	    dNdr(3,2,g1,g2) = 0.25d0 * (1.+r)		! dN3(r,s)/ds
	    dNdr(4,2,g1,g2) = 0.25d0 * (1.-r)		! dN4(r,s)/ds

! Jij is the Jacobian matrix
	    J(1,1,g1,g2) = dNdr(1,1,g1,g2)*x(i1,1) + dNdr(2,1,g1,g2)*x(i2,1) + &
			   dNdr(3,1,g1,g2)*x(i3,1) + dNdr(4,1,g1,g2)*x(i4,1)	! x,r
	    J(1,2,g1,g2) = dNdr(1,2,g1,g2)*x(i1,1) + dNdr(2,2,g1,g2)*x(i2,1) + &
		     	   dNdr(3,2,g1,g2)*x(i3,1) + dNdr(4,2,g1,g2)*x(i4,1)	! x,s
	    J(2,1,g1,g2) = dNdr(1,1,g1,g2)*x(i1,2) + dNdr(2,1,g1,g2)*x(i2,2) + &
		     	   dNdr(3,1,g1,g2)*x(i3,2) + dNdr(4,1,g1,g2)*x(i4,2)	! y,r
	    J(2,2,g1,g2) = dNdr(1,2,g1,g2)*x(i1,2) + dNdr(2,2,g1,g2)*x(i2,2) + &
		     	   dNdr(3,2,g1,g2)*x(i3,2) + dNdr(4,2,g1,g2)*x(i4,2)	! y,s

	    Jac (g1,g2) = J(1,1,g1,g2)*J(2,2,g1,g2) - &
			  J(1,2,g1,g2)*J(2,1,g1,g2)	! Jacobian determinant, |J|
	    Jaci(g1,g2) = 1. / Jac(g1,g2)		! 1/|J|

! inv(Jij)
	    Ji(1,1,g1,g2) = J(2,2,g1,g2)*Jaci(g1,g2)
	    Ji(1,2,g1,g2) =-J(1,2,g1,g2)*Jaci(g1,g2)
	    Ji(2,1,g1,g2) =-J(2,1,g1,g2)*Jaci(g1,g2)
	    Ji(2,2,g1,g2) = J(1,1,g1,g2)*Jaci(g1,g2)

! Wi(r,s)
	    Wgt(1,g1,g2) =  Shp(1,g1,g2) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(1,1,g1,g2)*V(e,1)*Ji(1,1,g1,g2) + &
			      dNdr(1,2,g1,g2)*V(e,1)*Ji(2,1,g1,g2) + &
			      dNdr(1,1,g1,g2)*V(e,2)*Ji(1,2,g1,g2) + &
			      dNdr(1,2,g1,g2)*V(e,2)*Ji(2,2,g1,g2) )	! W1(r,s)
	    Wgt(2,g1,g2) =  Shp(2,g1,g2) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(2,1,g1,g2)*V(e,1)*Ji(1,1,g1,g2) + &
			      dNdr(2,2,g1,g2)*V(e,1)*Ji(2,1,g1,g2) + &
			      dNdr(2,1,g1,g2)*V(e,2)*Ji(1,2,g1,g2) + &
			      dNdr(2,2,g1,g2)*V(e,2)*Ji(2,2,g1,g2) )	! W2(r,s)
	    Wgt(3,g1,g2) =  Shp(3,g1,g2) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(3,1,g1,g2)*V(e,1)*Ji(1,1,g1,g2) + &
			      dNdr(3,2,g1,g2)*V(e,1)*Ji(2,1,g1,g2) + &
			      dNdr(3,1,g1,g2)*V(e,2)*Ji(1,2,g1,g2) + &
			      dNdr(3,2,g1,g2)*V(e,2)*Ji(2,2,g1,g2) )	! W3(r,s)
	    Wgt(4,g1,g2) =  Shp(4,g1,g2) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(4,1,g1,g2)*V(e,1)*Ji(1,1,g1,g2) + &
			      dNdr(4,2,g1,g2)*V(e,1)*Ji(2,1,g1,g2) + &
			      dNdr(4,1,g1,g2)*V(e,2)*Ji(1,2,g1,g2) + &
			      dNdr(4,2,g1,g2)*V(e,2)*Ji(2,2,g1,g2) )	! W4(r,s)
! check element geometry
	    if(Jac(g1,g2) .le. 0.) then
	      write(iout,*) '*** ABORT: Jac(g1,g2) <= 0, e, g1, g2, Jac(g1,g2) = ', &
							 e ,g1, g2, Jac(g1,g2)
	      ierror = ierror + 1
	    endif

	  enddo	! g2
	enddo	! g1

	if(ierror .ne. 0) then
	  write(iout,*) '*** ABORT: ierror = ', ierror
	  stop
	endif
	
	return
	end
